/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.mapui.dialog;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.mapui.VWDesignerWorkflowPane;
import filenet.vw.toolkit.design.mapui.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.mapui.VWMapCache;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VWMapsDialog
extends VWModalDialog
implements ActionListener,
ListSelectionListener {
    private static final Dimension DIM_DIALOG_SIZE = new Dimension(440, 275);
    public static final int STATUS_GOTO = 0;
    public static final int STATUS_CANCEL = 1;
    public static final int STATUS_HELP = 2;
    private JComboBox m_categoryComboBox = null;
    private JList m_mapsListBox = null;
    private JButton m_gotoButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private GridBagConstraints m_gbCons = null;
    private VWMapCache m_mapCache = null;
    private int m_nStatus = 1;
    private String m_mapName = null;
    private String m_currentMapName = null;
    private String m_mainMapName = null;

    public VWMapsDialog(Frame parent, String currentMapName, VWMapCache mapCache) {
        super(parent);
        this.m_currentMapName = currentMapName;
        this.m_mapCache = mapCache;
        this.init();
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public String getMapName() {
        return this.m_mapName;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this.m_cancelButton) {
                this.performCancel();
            } else if (source == this.m_gotoButton) {
                this.performGoto();
            } else if (source == this.m_helpButton) {
                this.performHelp();
            } else if (source == this.m_categoryComboBox) {
                this.updateMapsListBox();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource() == this.m_mapsListBox) {
            String mapName = (String)this.m_mapsListBox.getSelectedValue();
            this.m_mapName = VWStringUtils.compare(mapName, this.m_mainMapName) == 0 ? "Workflow" : mapName;
            this.m_gotoButton.setEnabled(true);
        }
    }

    private void init() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.setTitle(VWResource.s_gotoSubmapStr);
        this.setSize(DIM_DIALOG_SIZE);
        this.m_mainMapName = VWResource.s_mainMapLabel.toString("Workflow");
        if (VWStringUtils.compare("Workflow", this.m_currentMapName) == 0) {
            this.m_currentMapName = this.m_mainMapName;
        }
        this.initCategoryControl();
        this.initMapsListControl();
        this.initDialogControls();
        this.updateMapsListBox();
    }

    private void initCategoryControl() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 2;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.insets = new Insets(2, 2, 2, 2);
        this.m_categoryComboBox = new JComboBox();
        this.m_categoryComboBox.setRenderer(new VWLabelListCellRenderer());
        this.m_categoryComboBox.addItem(VWResource.s_allMapsStr);
        this.m_categoryComboBox.addItem(VWResource.s_writeableMapsStr);
        this.m_categoryComboBox.addItem(VWResource.s_readOnlyInheritedMapsStr);
        this.m_categoryComboBox.addItem(VWResource.s_callerMapsStr);
        this.m_categoryComboBox.addActionListener(this);
        this.getContentPane().add((Component)this.m_categoryComboBox, this.m_gbCons);
    }

    private void initMapsListControl() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 1;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.insets = new Insets(2, 2, 2, 2);
        this.m_mapsListBox = new JList();
        this.m_mapsListBox.setModel(new VWSortedListModel());
        this.m_mapsListBox.setSelectionMode(0);
        this.m_mapsListBox.addListSelectionListener(this);
        this.getContentPane().add((Component)new JScrollPane(this.m_mapsListBox), this.m_gbCons);
    }

    private void initDialogControls() {
        JPanel clientPanel = new JPanel();
        clientPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.weightx = 0.3;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(0, 0, 0, 5);
        this.m_gotoButton = new JButton(VWResource.s_ok);
        this.m_gotoButton.setEnabled(false);
        this.m_gotoButton.addActionListener(this);
        clientPanel.add((Component)this.m_gotoButton, gbCons);
        ++gbCons.gridx;
        this.m_cancelButton = new JButton(VWResource.s_cancel);
        this.m_cancelButton.addActionListener(this);
        clientPanel.add((Component)this.m_cancelButton, gbCons);
        ++gbCons.gridx;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_helpButton = new JButton(VWResource.s_help);
        this.m_helpButton.addActionListener(this);
        clientPanel.add((Component)this.m_helpButton, gbCons);
        this.m_gbCons.anchor = 10;
        this.m_gbCons.fill = 0;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 3;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.insets = new Insets(8, 2, 8, 2);
        this.getContentPane().add((Component)clientPanel, this.m_gbCons);
    }

    private void performCancel() {
        this.m_nStatus = 1;
        this.m_mapName = null;
        this.setVisible(false);
    }

    private void performGoto() {
        this.m_nStatus = 0;
        this.setVisible(false);
    }

    private void performHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh149.htm");
    }

    private void updateMapsListBox() {
        try {
            String category = (String)this.m_categoryComboBox.getSelectedItem();
            if (VWStringUtils.compare(category, VWResource.s_allMapsStr) == 0) {
                this.showAllMaps();
            } else if (VWStringUtils.compare(category, VWResource.s_writeableMapsStr) == 0) {
                this.showWritableMaps();
            } else if (VWStringUtils.compare(category, VWResource.s_readOnlyInheritedMapsStr) == 0) {
                this.showReadOnlySystemMaps();
            } else {
                this.showCallerMaps();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showAllMaps() {
        try {
            VWMapDefinition[] mapDefs;
            VWSortedListModel listModel = (VWSortedListModel)this.m_mapsListBox.getModel();
            listModel.removeAllElements();
            listModel.addElement(this.m_mainMapName);
            if (this.m_mapCache != null && (mapDefs = this.m_mapCache.getMapDefinitions()) != null && mapDefs.length > 0) {
                Vector<String> mapNames = new Vector<String>();
                for (int i = 0; i < mapDefs.length; ++i) {
                    String mapName = mapDefs[i].getName();
                    if (VWStringUtils.compare(mapName, "Workflow") == 0) continue;
                    mapNames.addElement(mapName);
                }
                Object[] maps = new String[mapNames.size()];
                mapNames.copyInto(maps);
                VWQuickSort quicksort = new VWQuickSort(maps, 0);
                quicksort.sort(0, maps.length - 1);
                for (int i = 0; i < maps.length; ++i) {
                    listModel.addElement(maps[i]);
                }
            }
            this.selectMapsListItem(true, true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showWritableMaps() {
        try {
            VWSortedListModel listModel = (VWSortedListModel)this.m_mapsListBox.getModel();
            listModel.removeAllElements();
            this.m_gotoButton.setEnabled(false);
            boolean foundCurrentMapInList = false;
            boolean foundSelectedMapInList = false;
            if (this.m_mapCache != null) {
                VWMapDefinition[] mapDefs;
                if (this.m_mapCache.get("Workflow", false) != null) {
                    listModel.addElement(this.m_mainMapName);
                }
                if ((mapDefs = this.m_mapCache.getCurrentMapDefinitions()) != null && mapDefs.length > 0) {
                    Vector<String> mapNames = new Vector<String>();
                    for (int i = 0; i < mapDefs.length; ++i) {
                        String mapName = mapDefs[i].getName();
                        if (VWStringUtils.compare(mapName, "Workflow") == 0) continue;
                        mapNames.addElement(mapName);
                        if (!foundCurrentMapInList && VWStringUtils.compare(mapName, this.m_currentMapName) == 0) {
                            foundCurrentMapInList = true;
                        }
                        if (foundSelectedMapInList || VWStringUtils.compare(mapName, this.m_mapName) != 0) continue;
                        foundSelectedMapInList = true;
                    }
                    Object[] maps = new String[mapNames.size()];
                    mapNames.copyInto(maps);
                    VWQuickSort quicksort = new VWQuickSort(maps, 0);
                    quicksort.sort(0, maps.length - 1);
                    for (int i = 0; i < maps.length; ++i) {
                        listModel.addElement(maps[i]);
                    }
                }
            }
            this.selectMapsListItem(foundCurrentMapInList, foundSelectedMapInList);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showReadOnlySystemMaps() {
        try {
            VWMapDefinition[] mapDefs;
            VWSortedListModel listModel = (VWSortedListModel)this.m_mapsListBox.getModel();
            listModel.removeAllElements();
            boolean foundCurrentMapInList = false;
            boolean foundSelectedMapInList = false;
            if (this.m_mapCache != null && this.m_mapCache.get("Workflow", false) == null) {
                listModel.addElement(this.m_mainMapName);
                if (VWStringUtils.compare(this.m_currentMapName, this.m_mainMapName) == 0) {
                    foundCurrentMapInList = true;
                }
                if (this.m_mapName != null && VWStringUtils.compare(this.m_mapName, "Workflow") == 0) {
                    foundSelectedMapInList = true;
                }
            }
            if (this.m_mapCache != null && (mapDefs = this.m_mapCache.getBaseMapDefinitions()) != null && mapDefs.length > 0) {
                Vector<String> mapNames = new Vector<String>();
                for (int i = 0; i < mapDefs.length; ++i) {
                    String mapName = mapDefs[i].getName();
                    if (!VWDesignerWorkflowPane.isSystemMap(mapName) || VWStringUtils.compare(mapName, "Workflow") == 0 || this.m_mapCache.get(mapName, false) != null) continue;
                    mapNames.addElement(mapName);
                    if (!foundCurrentMapInList && VWStringUtils.compare(this.m_currentMapName, mapName) == 0) {
                        foundCurrentMapInList = true;
                    }
                    if (foundSelectedMapInList || this.m_mapName == null || VWStringUtils.compare(this.m_mapName, mapName) != 0) continue;
                    foundSelectedMapInList = true;
                }
                Object[] maps = new String[mapNames.size()];
                mapNames.copyInto(maps);
                VWQuickSort quicksort = new VWQuickSort(maps, 0);
                quicksort.sort(0, maps.length - 1);
                for (int i = 0; i < maps.length; ++i) {
                    listModel.addElement(maps[i]);
                }
            }
            this.selectMapsListItem(foundCurrentMapInList, foundSelectedMapInList);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showCallerMaps() {
        try {
            int mapDefsSize;
            VWMapDefinition[] mapDefs;
            String currentMapName = VWStringUtils.compare(this.m_currentMapName, this.m_mainMapName) == 0 ? "Workflow" : this.m_currentMapName;
            VWSortedListModel listModel = (VWSortedListModel)this.m_mapsListBox.getModel();
            listModel.removeAllElements();
            boolean foundSelectedMapInList = false;
            if (this.m_mapCache != null && (mapDefs = this.m_mapCache.getMapDefinitions()) != null && (mapDefsSize = mapDefs.length) > 0) {
                Vector<String> mapNames = new Vector<String>();
                block2: for (int i = 0; i < mapDefsSize; ++i) {
                    int mapNodesSize;
                    VWMapNode[] mapNodes = mapDefs[i].getSteps();
                    if (mapNodes == null || (mapNodesSize = mapNodes.length) <= 0) continue;
                    for (int j = 0; j < mapNodesSize; ++j) {
                        String mapName;
                        int stepType = VWStepUtils.getStepType(mapNodes[j]);
                        if (stepType != 9 && stepType != 10 || (mapName = VWStepUtils.getCalledMapName(mapNodes[j])) == null || VWStringUtils.compare(mapName, currentMapName) != 0) continue;
                        String callerMapName = mapDefs[i].getName();
                        mapNames.addElement(callerMapName);
                        if (foundSelectedMapInList || this.m_mapName == null || VWStringUtils.compare(callerMapName, this.m_mapName) != 0) continue block2;
                        foundSelectedMapInList = true;
                        continue block2;
                    }
                }
                int size = mapNames.size();
                if (size > 0) {
                    Object[] maps = new String[mapNames.size()];
                    mapNames.copyInto(maps);
                    VWQuickSort quicksort = new VWQuickSort(maps, 0);
                    quicksort.sort(0, maps.length - 1);
                    for (int i = 0; i < size; ++i) {
                        if (VWStringUtils.compare((String)maps[i], "Workflow") != 0) continue;
                        listModel.addElement(this.m_mainMapName);
                        if (foundSelectedMapInList || this.m_mapName == null || VWStringUtils.compare(this.m_mapName, "Workflow") != 0) continue;
                        foundSelectedMapInList = true;
                    }
                }
            }
            this.selectMapsListItem(false, foundSelectedMapInList);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void selectMapsListItem(boolean foundCurrentMapInList, boolean foundSelectedMapInList) {
        if (this.m_mapName != null) {
            if (foundSelectedMapInList) {
                this.m_mapsListBox.setSelectedValue(VWStringUtils.compare(this.m_mapName, "Workflow") == 0 ? this.m_mainMapName : this.m_mapName, true);
                this.m_gotoButton.setEnabled(true);
            } else {
                this.m_gotoButton.setEnabled(false);
            }
        } else if (this.m_currentMapName != null) {
            if (foundCurrentMapInList) {
                this.m_mapsListBox.setSelectedValue(this.m_currentMapName, true);
                this.m_gotoButton.setEnabled(true);
            } else {
                this.m_gotoButton.setEnabled(false);
            }
        } else {
            this.m_gotoButton.setEnabled(false);
        }
    }
}

